VERSION 5.00
Object = "{1F8AB572-28EC-4562-B4CC-A7549ECAF20B}#0.9#0"; "FeedForDevX.ocx"
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCOMCTL.OCX"
Object = "{86CF1D34-0C5F-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCOMCT2.OCX"
Begin VB.Form frmDemo 
   Caption         =   "Form1"
   ClientHeight    =   8175
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   7980
   LinkTopic       =   "Form1"
   ScaleHeight     =   8175
   ScaleWidth      =   7980
   StartUpPosition =   3  'Windows Default
   Begin FeedForDevX.ffdRSSReader ffdRSSReader1 
      Left            =   120
      Top             =   7440
      ItemNumber      =   0
      Address         =   ""
      Blocking        =   -1  'True
      CategoryFilter  =   ""
      PubDateStart    =   23981
      PubDateEnd      =   53181
      PubDateSort     =   0
      PubDateFilter   =   0   'False
      LicenseName     =   ""
      LicenseSN       =   ""
      LicenseKey      =   ""
      Registered      =   0   'False
      DoubleBuffered  =   0   'False
      Enabled         =   -1  'True
      Visible         =   -1  'True
   End
   Begin MSComctlLib.StatusBar stbStatus 
      Align           =   2  'Align Bottom
      Height          =   375
      Left            =   0
      TabIndex        =   27
      Top             =   7800
      Width           =   7980
      _ExtentX        =   14076
      _ExtentY        =   661
      _Version        =   393216
      BeginProperty Panels {8E3867A5-8586-11D1-B16A-00C0F0283628} 
         NumPanels       =   4
         BeginProperty Panel1 {8E3867AB-8586-11D1-B16A-00C0F0283628} 
            Object.Width           =   3175
            MinWidth        =   3175
            Text            =   "Status: No Feed"
            TextSave        =   "Status: No Feed"
         EndProperty
         BeginProperty Panel2 {8E3867AB-8586-11D1-B16A-00C0F0283628} 
            Object.Width           =   2822
            MinWidth        =   2822
            Text            =   "Current Items: 0"
            TextSave        =   "Current Items: 0"
         EndProperty
         BeginProperty Panel3 {8E3867AB-8586-11D1-B16A-00C0F0283628} 
            Object.Width           =   2822
            MinWidth        =   2822
            Text            =   "Total Items: 0"
            TextSave        =   "Total Items: 0"
         EndProperty
         BeginProperty Panel4 {8E3867AB-8586-11D1-B16A-00C0F0283628} 
            AutoSize        =   1
            Object.Width           =   4666
            MinWidth        =   3528
            Text            =   "License: Un-Registered"
            TextSave        =   "License: Un-Registered"
         EndProperty
      EndProperty
   End
   Begin VB.Frame grpAdvanced 
      Caption         =   "Advanced"
      Height          =   4215
      Left            =   240
      TabIndex        =   8
      Top             =   3240
      Width           =   7500
      Begin VB.CommandButton btnRawFeed 
         Caption         =   "View Raw Feed"
         Height          =   495
         Left            =   4080
         TabIndex        =   14
         Top             =   3360
         Width           =   2895
      End
      Begin VB.CommandButton btnShowItems 
         Caption         =   "Show Feed Items"
         Height          =   495
         Left            =   4080
         TabIndex        =   13
         Top             =   2760
         Width           =   2895
      End
      Begin VB.CommandButton btnGetFeedItems 
         Caption         =   "Get Feed Items"
         Height          =   495
         Left            =   4080
         TabIndex        =   12
         Top             =   2160
         Width           =   2895
      End
      Begin VB.Frame grpRetrievalOptions 
         Caption         =   "Retrieval Options"
         Height          =   1455
         Left            =   4080
         TabIndex        =   11
         Top             =   360
         Width           =   2895
         Begin VB.OptionButton optEvent 
            Caption         =   "Event Driven"
            Height          =   255
            Left            =   360
            TabIndex        =   25
            Top             =   720
            Width           =   1335
         End
         Begin VB.OptionButton optBlocking 
            Caption         =   "Blocking Call"
            Height          =   255
            Left            =   360
            TabIndex        =   24
            Top             =   360
            Value           =   -1  'True
            Width           =   1335
         End
      End
      Begin VB.Frame grpPDSortOptions 
         Caption         =   "PubDate Sort Options"
         Height          =   1575
         Left            =   360
         TabIndex        =   10
         Top             =   2280
         Width           =   3015
         Begin VB.OptionButton optSortAscending 
            Caption         =   "Sort Ascending"
            Height          =   255
            Left            =   360
            TabIndex        =   23
            Top             =   720
            Width           =   1815
         End
         Begin VB.OptionButton optSortDescending 
            Caption         =   "Sort Descending"
            Height          =   255
            Left            =   360
            TabIndex        =   22
            Top             =   1080
            Width           =   1815
         End
         Begin VB.OptionButton optSortNone 
            Caption         =   "No Sorting"
            Height          =   255
            Left            =   360
            TabIndex        =   21
            Top             =   360
            Value           =   -1  'True
            Width           =   1815
         End
      End
      Begin VB.Frame grpFiltering 
         Caption         =   "Item Filtering"
         Height          =   1725
         Left            =   360
         TabIndex        =   9
         Top             =   360
         Width           =   3015
         Begin MSComCtl2.DTPicker dtpStartDate 
            Height          =   300
            Left            =   960
            TabIndex        =   19
            Top             =   840
            Width           =   1815
            _ExtentX        =   3201
            _ExtentY        =   529
            _Version        =   393216
            Format          =   24510465
            CurrentDate     =   38581
         End
         Begin VB.TextBox edtCategory 
            Height          =   285
            Left            =   960
            TabIndex        =   18
            Top             =   360
            Width           =   1815
         End
         Begin MSComCtl2.DTPicker dtpEndDate 
            Height          =   300
            Left            =   960
            TabIndex        =   20
            Top             =   1200
            Width           =   1815
            _ExtentX        =   3201
            _ExtentY        =   529
            _Version        =   393216
            Format          =   24510465
            CurrentDate     =   38581
         End
         Begin VB.Label lblEndDate 
            Caption         =   "End Date"
            Height          =   255
            Left            =   120
            TabIndex        =   17
            Top             =   1200
            Width           =   1095
         End
         Begin VB.Label lblStartDate 
            Caption         =   "Start Date"
            Height          =   255
            Left            =   120
            TabIndex        =   16
            Top             =   840
            Width           =   1095
         End
         Begin VB.Label lblCategory 
            Caption         =   "Category"
            Height          =   255
            Left            =   120
            TabIndex        =   15
            Top             =   360
            Width           =   1215
         End
      End
   End
   Begin VB.Frame grpExamples 
      Caption         =   "Examples"
      Height          =   2055
      Left            =   240
      TabIndex        =   3
      Top             =   1080
      Width           =   7500
      Begin VB.CommandButton btnNews 
         Caption         =   "Application News"
         Height          =   495
         Left            =   4080
         TabIndex        =   7
         Top             =   480
         Width           =   2895
      End
      Begin VB.CommandButton btnSpecials 
         Caption         =   "Specials"
         Height          =   495
         Left            =   4080
         TabIndex        =   6
         Top             =   1200
         Width           =   2895
      End
      Begin VB.CommandButton btnTricks 
         Caption         =   "Tips and Tricks"
         Height          =   495
         Left            =   480
         TabIndex        =   5
         Top             =   1200
         Width           =   2895
      End
      Begin VB.CommandButton btnVersion 
         Caption         =   "Check Version Info"
         Height          =   495
         Left            =   480
         TabIndex        =   4
         Top             =   480
         Width           =   2895
      End
   End
   Begin VB.Frame grpFeed 
      Caption         =   "RSS Feed"
      Height          =   900
      Left            =   240
      TabIndex        =   0
      Top             =   120
      Width           =   7500
      Begin VB.TextBox edtRssFeedUrl 
         Height          =   285
         Left            =   1440
         TabIndex        =   2
         Text            =   "http://www.feedfordev.com/sample-feed.xml"
         Top             =   330
         Width           =   5655
      End
      Begin VB.Label lblRssFeedUrl 
         Caption         =   "RSS Feed URL"
         Height          =   255
         Left            =   240
         TabIndex        =   1
         Top             =   360
         Width           =   1215
      End
   End
   Begin VB.Label lblRegMessage 
      Caption         =   "*note: unregistered versions of FeedForDev will randomly return an 'unregistered' message in item data"
      Height          =   255
      Left            =   360
      TabIndex        =   26
      Top             =   7560
      Width           =   7335
   End
End
Attribute VB_Name = "frmDemo"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Const ProgramVersion = "1.0"

Dim FeedUrlModified As Boolean
Dim FeedIsLoaded As Boolean
Private Sub Label1_Click()

End Sub

Private Sub btnGetFeedItems_Click()

' Retrieves feed if necessary and loads in current items
' according to category and date settings
  
' load settings from screen into control
ffdRSSReader1.Address = Trim(edtRssFeedUrl.Text)
' set retrieval behavior
If optBlocking Then
    ffdRSSReader1.Blocking = True
Else
    ffdRSSReader1.Blocking = False
End If
' set sort order for retrieved items
If optSortNone Then
    ffdRSSReader1.PubDateSort = pdsNone
Else
    If optSortAscending Then
        ffdRSSReader1.PubDateSort = pdsAscending
    Else
        ffdRSSReader1.PubDateSort = pdsDescending
    End If
End If
If Not FeedIsLoaded Then
    ' The RSS feed entered into the address field hasn't been loaded
    ffdRSSReader1.GetFeed
    ' if the control is set to use non-blocking retrieval (event drived)
    ' then we are done here, because the data will be read when the
    ' OnFinished event is fired by the control.  Otherwise read the
    ' resulting data now
    If ffdRSSReader1.Blocking Then
        ' blocking, so retrieval is done by now
        ' first check for errors
        If ffdRSSReader1.ErrorCode <> ecNone Then
            ' got an error downloading the feed
            ' update the status bar
            stbStatus.Panels(1).Text = "Status: Error"
            stbStatus.Panels(2).Text = "Current Items: 0"
            stbStatus.Panels(3).Text = "Total Items: 0"
            If ffdRSSReader1.Registered Then
                stbStatus.Panels(4).Text = "License: Registered"
            Else
                stbStatus.Panels(4).Text = "License: Un-Registered"
            End If
            ' show message about failure
            MsgBox ("Opening the RSS feed gave the following error: " + ffdRSSReader1.ErrorDescription)
        Else
            ' RSS feed sucessfully retrieved and parsed
            ' update the status bar
            stbStatus.Panels(1).Text = "Status: Loaded"
            stbStatus.Panels(3).Text = "Total Items: " + Str(ffdRSSReader1.ItemCount)
            If ffdRSSReader1.Registered Then
                stbStatus.Panels(4).Text = "License: Registered"
            Else
                stbStatus.Panels(4).Text = "License: Un-Registered"
            End If
            ' now use the rest of the settings from the screen to filter which items
            ' should be currently available
            ffdRSSReader1.CategoryFilter = Trim(edtCategory.Text)
            ffdRSSReader1.PubDateStart = dtpStartDate
            ffdRSSReader1.PubDateEnd = dtpEndDate
            ' now ask for all the items in the feed that meet the criteria
            ffdRSSReader1.GetItems
            ' update the status bar
            stbStatus.Panels(2).Text = "Current Items: " + Str(ffdRSSReader1.ItemCount)
        End If
    End If
    FeedIsLoaded = True
Else
    ' the feed has already been loaded previously, so we just need to use the settings
    ' from the screen to re-filter the items
    ffdRSSReader1.CategoryFilter = Trim(edtCategory.Text)
    ffdRSSReader1.PubDateStart = dtpStartDate
    ffdRSSReader1.PubDateEnd = dtpEndDate
    ' now ask for all the items in the feed that meet the criteria
    ffdRSSReader1.GetItems
    ' update the status bar
    stbStatus.Panels(2).Text = "Current Items: " + Str(ffdRSSReader1.ItemCount)
End If

End Sub

Private Sub btnNews_Click()
' displays any news items in another form with
' a memo field

Dim Counter As Integer
  
' set the category
edtCategory.Text = "news"
' reset date fields in case they were changed by the user
dtpStartDate = CDate("01/01/2001")
dtpEndDate = CDate("01/01/2099")
' get matching items
btnGetFeedItems_Click
' clear the memo box
frmMemo.mmoFeedData = ""
' check to see if any items were found in the feed
' if so, display them
Counter = 1
Do While Counter <= ffdRSSReader1.ItemCount
    ' set which item to display info from
    ffdRSSReader1.ItemNumber = Counter
    ' add news item to memo box
    frmMemo.mmoFeedData = frmMemo.mmoFeedData + ffdRSSReader1.ItemTitle
    frmMemo.mmoFeedData = frmMemo.mmoFeedData + ffdRSSReader1.ItemDescription
    ' add blank line between items
    frmMemo.mmoFeedData = frmMemo.mmoFeedData + vbCrLf
    ' move on to the next item
    Counter = Counter + 1
Loop
' if there weren"t any items, then show message about that
If Counter > 1 Then
    ' show the memo form
    frmMemo.Show 1
Else
    ' otherwise say there were not news items
    MsgBox ("There weren't any news items in the feed")
End If

End Sub

Private Sub btnRawFeed_Click()
' this will show the feed's raw source data
  
' clear the memo field
frmMemo.mmoFeedData = ""
' add the raw source to the memo field
frmMemo.mmoFeedData.Text = ffdRSSReader1.RawFeed
frmMemo.Show 1

End Sub

Private Sub btnShowItems_Click()
' displays the title, description, and link for each item in the feed
' that matches the filter criteria (i.e. category, start and end dates)

Dim Counter As Integer
Dim NewItem As String

' clear memo
frmMemo.mmoFeedData = ""
' add feed"s title and pubdate
frmMemo.mmoFeedData.Text = frmMemo.mmoFeedData.Text + ffdRSSReader1.FeedTitle + " - " + _
        FormatDateTime(ffdRSSReader1.FeedPubDate) + vbCrLf + vbCrLf
Counter = 1
Do While Counter <= ffdRSSReader1.ItemCount
  ' set the current item
  ffdRSSReader1.ItemNumber = Counter
  ' add the item's fields to the memo box
  NewItem = "Item # " + Str(Counter) + vbCrLf + _
        "Title: " + ffdRSSReader1.ItemTitle + vbCrLf + _
        "Description: " + ffdRSSReader1.ItemDescription + vbCrLf + _
        "Link: " + ffdRSSReader1.ItemLink + vbCrLf + _
        "PubDate: " + FormatDateTime(ffdRSSReader1.ItemPubDate) + vbCrLf + vbCrLf
  frmMemo.mmoFeedData.Text = frmMemo.mmoFeedData.Text + NewItem
  ' move to next item
  Counter = Counter + 1
Loop
If Counter > 1 Then
  ' at least one item was found, so show memo form
  frmMemo.Show 1
Else
  ' there aren"t any current items, so say so
  MsgBox ("There aren't any current items to display")
End If

End Sub


Private Sub btnSpecials_Click()
' sets the category to "special" to retrieve any entries
' in the feed that are specials

Dim Counter As Integer

' set the category
edtCategory.Text = "special"
' reset date fields in case they were changed by the user
dtpStartDate = CDate("01/01/2001")
dtpEndDate = CDate("01/01/2099")
' get matching items
btnGetFeedItems_Click
' check to see if any items were found in the feed
' if so, display them
Counter = 1
Do While Counter <= ffdRSSReader1.ItemCount
    ' set which item to display info from
    ffdRSSReader1.ItemNumber = Counter
    ' display tip in a message box
    MsgBox (ffdRSSReader1.ItemTitle + vbCrLf + ffdRSSReader1.ItemDescription + vbCrLf + "For more info go here: " + ffdRSSReader1.ItemLink)
    ' move on to the next item
    Counter = Counter + 1
Loop
' if there weren"t any items, then show message about that
If Counter = 1 Then
    MsgBox ("There weren't any specials in the feed")
End If

End Sub

Private Sub btnTricks_Click()
' sets the category to "tip" to retrieve any entries
' in the feed that are tips & tricks entries

Dim Counter As Integer
  
' set the category
edtCategory.Text = "tip"
' reset date fields in case they were changed by the user
dtpStartDate = CDate("01/01/2001")
dtpEndDate = CDate("01/01/2099")
' get matching items
btnGetFeedItems_Click
' check to see if any items were found in the feed
' if so, display them
Counter = 1
Do While Counter <= ffdRSSReader1.ItemCount
    ' set which item to display info from
    ffdRSSReader1.ItemNumber = Counter
    ' display tip in a message box
    MsgBox (ffdRSSReader1.ItemTitle + vbCrLf + ffdRSSReader1.ItemDescription)
    ' move on to the next item
    Counter = Counter + 1
Loop
' if there weren"t any items, then show message about that
If Counter = 1 Then
    MsgBox ("There weren't any tips in the feed")
End If

End Sub

Private Sub btnVersion_Click()
' sets the category to "version" to retrieve any entries
' in the feed that are version entries, and then compares
' it to the current demo program version
  
' set the category
edtCategory.Text = "version"
' reset date fields in case they were changed by the user
dtpStartDate = CDate("01/01/2001")
dtpEndDate = CDate("01/01/2099")
' get matching items
btnGetFeedItems_Click
' check to see if a version item was found in the feed
If ffdRSSReader1.ItemCount > 0 Then
    ' found version entry in feed.  Compare it to the version of the
    ' current program.  I am just using a constant set to 1.0 here,
    ' in a real program you would do something better
    If ProgramVersion < Trim(ffdRSSReader1.ItemTitle) Then
        ' a version item was found with a newer version
        ' display the text from the feed"s description field
        ' wich could contain info about the new version
        MsgBox (ffdRSSReader1.ItemDescription)
    Else
        MsgBox ("Your program is up to date")
    End If
Else
  MsgBox ("There are no version items in that feed")
End If

End Sub

Private Sub edtRssFeedUrl_Change()
    FeedUrlModified = True
End Sub

Private Sub edtRssFeedUrl_LostFocus()

' check to see if the url of the feed has changed
If FeedUrlModified Then
    ' the url has been changed, so reset the status bar values
    stbStatus.Panels(1).Text = "Status: No Feed"
    stbStatus.Panels(2).Text = "Current Items: 0"
    stbStatus.Panels(3).Text = "Total Items: 0"
    If ffdRSSReader1.Registered Then
        stbStatus.Panels(4).Text = "License: Registered"
    Else
        stbStatus.Panels(4).Text = "License: Un-Registered"
    End If
End If
' set feed loaded status to false
FeedIsLoaded = False
' reset the modifed flag
FeedUrlModified = False

End Sub


Private Sub ffdRSSReader1_OnFinished()
' When the control's "Blocking" property is set to false,
' it runs in an event-driven mode and returns immediately
' from the "GetFeed" call.  This event is fired when the
' retrieval of the feed is finished
  
' first check for errors
If ffdRSSReader1.ErrorCode <> ecNone Then
    ' got an error downloading the feed
    ' update the status bar
    stbStatus.Panels(1).Text = "Status: Error"
    stbStatus.Panels(2).Text = "Current Items: 0"
    stbStatus.Panels(3).Text = "Total Items: 0"
    If ffdRSSReader1.Registered Then
        stbStatus.Panels(4).Text = "License: Registered"
    Else
        stbStatus.Panels(4).Text = "License: Un-Registered"
    End If
    ' show message about failure
    MsgBox ("Opening the RSS feed gave the following error: " + ffdRSSReader1.ErrorDescription)
Else
    ' RSS feed sucessfully retrieved and parsed
    ' update the status bar
    stbStatus.Panels(1).Text = "Status: Loaded"
    stbStatus.Panels(3).Text = "Total Items: " + Str(ffdRSSReader1.ItemCount)
    If ffdRSSReader1.Registered Then
        stbStatus.Panels(4).Text = "License: Registered"
    Else
        stbStatus.Panels(4).Text = "License: Un-Registered"
    End If
    ' now use the rest of the settings from the screen to filter which items
    ' should be currently available
    ffdRSSReader1.CategoryFilter = Trim(edtCategory.Text)
    ffdRSSReader1.PubDateStart = dtpStartDate
    ffdRSSReader1.PubDateEnd = dtpEndDate
    ' now ask for all the items in the feed that meet the criteria
    ffdRSSReader1.GetItems
    ' update the status bar
    stbStatus.Panels(2).Text = "Current Items: " + Str(ffdRSSReader1.ItemCount)
End If

End Sub


Private Sub Form_Load()
  If ffdRSSReader1.Registered Then
    stbStatus.Panels(4).Text = "License: Registered"
  Else
    stbStatus.Panels(4).Text = "License: Un-Registered"
  End If
End Sub


Private Sub StatusBar1_PanelClick(ByVal Panel As MSComctlLib.Panel)

End Sub


